#include <iostream>
#include <fstream>

#include "rentalAgency.h"
#include "rentalCar.h"
using namespace std;

//const int MAX_STRING_LENGTH = 50;
const int MAX_NUM_AGENCIES = 10;

//struct rentalCar
//{
//	char make[MAX_STRING_LENGTH];
//	char model[MAX_STRING_LENGTH];
//	int year;
//	float price;
//	bool availability;
//};

//void readFile(char fileName[], rentalCar[]);
//void displayCarData(rentalCar cars);
//void carEstimate(rentalCar car, int days);
//void mostExpensive(rentalCar cars[]);
//void availableCars(rentalCar cars[]);

int compare(char* s1, char* s2)
{
	while (*s1 == *s2){
		if (*s1 == '\0' || *s2 == '\0')
			break;

		s1++;
		s2++;
	}

	if (*s1 == '\0' && *s2 == '\0')
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

RentalAgency* readFile(char filenName[], int& agencyCount)
{
	char name[MAX_STRING_LENGTH];
	int zipcode;
	char make[MAX_STRING_LENGTH];
	char model[MAX_STRING_LENGTH];
	int year;
	float price;
	bool available;

	RentalAgency agencies[MAX_NUM_AGENCIES];
	agencyCount = 0;

	ifstream inFile(filenName);

	while (inFile >> name >> zipcode)
	{
		RentalAgency agency(name, zipcode);
		// read 5 cars
		for (int i = 0; i < 5; i++)
		{
			inFile >> year >> make >> model >> price >> available;
			// create RentalCar object
			RentalCar car(make, model, year, price, available);
			agency.addCar(car);
		}
		agencies[agencyCount] = agency;
		agencyCount++;
	}

	return agencies;
}

void  displayCarData(RentalAgency agencies[], int count)
{
	for (int a = 0; a < count; a++)
	{
		agencies[a].display();
	}
}

float  estimateCarRentalCost(RentalAgency agencies[], int count)
{
	char agency[MAX_STRING_LENGTH];
	int carNumber;

	cout << "Enter car agency: ";
	scanf("%s", &agency);
	cout << "Enter car number [1-5]: ";
	cin >> carNumber;

	for (int i = 0; i < count; i++)
	{
		if (compare(agencies[i].getName(), agency) == 0)
		{
			return agencies[i].getCostByCarNumber(carNumber);
		}
	}

	return 0;
}

void  printAvailableCars(RentalAgency agencies[], int count)
{
	for (int i = 0; i < count; i++)
	{
		agencies[i].printAvailableCars();
	}
}

void  mostExpensiveCar(RentalAgency agencies[], int count)
{
	float maxPrice = 0;
	RentalCar expCar;
	for (int i = 0; i < count; i++)
	{
		if (agencies[i].mostExpensiveCar().getPrice() > maxPrice)
		{
			expCar = agencies[i].mostExpensiveCar();
			maxPrice = expCar.getPrice();
		}
	}

	expCar.displayCarData();
}


int showMenu();

int main()
{
	char nameOfFile[MAX_STRING_LENGTH];
	int menuChoice;
	bool programOn;
	RentalAgency* agencies;
	int agencyCount;
	float cost;

	std::cout << "Enter file name: ";
	std::cin >> nameOfFile;

	agencies = readFile(nameOfFile, agencyCount);

	do
	{

		menuChoice = showMenu();

		switch (menuChoice)
		{
		case 1:
			displayCarData(agencies, agencyCount);
			programOn = true;
			break;

		case 2:
			cost = estimateCarRentalCost(agencies, agencyCount);
			cout << "Estimated Cost: " << cost << endl;
			programOn = true;
			break;

		case 3:
			mostExpensiveCar(agencies, agencyCount);
			programOn = true;
			break;

		case 4:
			printAvailableCars(agencies, agencyCount);
			programOn = true;
			break;

		default:
			return 0;
			break;
		}

		std::cout << std::endl << "Press enter to go back to menu.";
		std::cin.ignore().get();

	} while (programOn);



}
//
//// reads in file that the user has input
//void readFile(char fileName[], rentalCar vehicles[])
//{
//	std::ifstream fileIn;
//	rentalCar read;
//	int carCount = 0;
//
//	fileIn.open(fileName);
//
//	while (fileIn >> read.year && carCount < MAX_NUM_CARS)
//	{
//		fileIn >> read.make;
//		fileIn >> read.model;
//		fileIn >> read.price;
//		fileIn >> read.availability;
//
//		vehicles[carCount] = read;
//		carCount++;
//	}
//
//}
//
////displays the data from the car file
//void displayCarData(rentalCar cars)
//{
//
//	std::cout << cars.year << " "
//		<< cars.make << " "
//		<< cars.model << " $"
//		<< cars.price << " per day "
//		<< "Available: ";
//
//	if (cars.availability == true)
//	{
//		std::cout << "true" << std::endl;
//	}
//	else
//	{
//		std::cout << "false" << std::endl;
//	}
//
//}
//
//// estimates the cost by which car the user wants multiplied by how many days.
//void carEstimate(rentalCar car, int days)
//{
//	float cost = 0.0;
//
//	cost = car.price * days;
//
//	std::cout << "Estimated cost of renting is: " << cost << std::endl;
//}
//
////loops through the cars to find the most expensive car by price
//void mostExpensive(rentalCar cars[])
//{
//	float max = 0.0;
//	int maxCar = 0;
//
//	for (int i = 0; i < 10; i++) {
//		if (cars[i].price > max) {
//			max = cars[i].price;
//			maxCar = i;
//		}
//	}
//
//	std::cout << "The most expensive car is: "
//		<< cars[maxCar].year << " "
//		<< cars[maxCar].make << " "
//		<< cars[maxCar].model << " $"
//		<< cars[maxCar].price << " per day Available: ";
//
//	if (cars[maxCar].availability == true)
//	{
//		std::cout << "true" << std::endl;
//	}
//	else
//	{
//		std::cout << "false" << std::endl;
//	}
//}
//
//// Loops through the cars and finds which cars have the availability as true and prints it.
//void availableCars(rentalCar cars[])
//{
//	for (int i = 0; i < 10; i++)
//	{
//		if (cars[i].availability == true)
//		{
//			displayCarData(cars[i]);
//		}
//	}
//
//}

// Shows the menu for the user, and get the input from what the user wants
int showMenu()
{
	int userInput;

	std::cout << std::endl << " Rental Car Service" << std::endl;
	std::cout << " ==================" << std::endl << std::endl;

	std::cout << "1. Print data for all cars" << std::endl;
	std::cout << "2. Estimate car rental cost" << std::endl;
	std::cout << "3. Find the most expensive car" << std::endl;
	std::cout << "4. Print data for available cars" << std::endl;
	std::cout << "5. Exit program" << std::endl << std::endl;
	std::cout << "Enter selection: ";

	std::cin >> userInput;

	std::cout << std::endl;

	return userInput;
}
